/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom;

import com.moulberry.axiom.i18n.AxiomI18n;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3675;

public class KeyPressOverlay {
    public static final int SCROLL_UP = -200;
    public static final int SCROLL_DOWN = -201;
    public static final int SCROLL_LEFT = -202;
    public static final int SCROLL_RIGHT = -203;
    private static Int2IntMap visuallyPressed = new Int2IntLinkedOpenHashMap();
    private static final IntSet currentlyPressed = new IntLinkedOpenHashSet();

    public static void addKey(int key) {
        if (currentlyPressed.add(key)) {
            visuallyPressed.put(key, 20);
            visuallyPressed.keySet().removeIf(k -> !currentlyPressed.contains(k));
        }
    }

    public static void removeKey(int key) {
        currentlyPressed.remove(key);
    }

    public static List<StringWithOpacity> getStrings() {
        if (visuallyPressed.isEmpty()) {
            return List.of();
        }
        ArrayList<StringWithOpacity> strings = new ArrayList<StringWithOpacity>();
        StringBuilder builder = new StringBuilder();
        boolean empty = true;
        int builderOpacity = 255;
        for (Int2IntMap.Entry entry : visuallyPressed.int2IntEntrySet()) {
            int opacity = entry.getIntValue() * 255 / 20;
            if (builderOpacity != opacity) {
                if (!builder.isEmpty()) {
                    strings.add(new StringWithOpacity(builder.toString(), builderOpacity));
                    builder.setLength(0);
                }
                builderOpacity = opacity;
            }
            if (!empty) {
                builder.append("+");
            } else {
                empty = false;
            }
            builder.append(KeyPressOverlay.getKeyString(entry.getIntKey()));
        }
        if (!builder.isEmpty()) {
            strings.add(new StringWithOpacity(builder.toString(), builderOpacity));
        }
        return strings;
    }

    private static String getKeyString(int key) {
        if (key < 0) {
            if (key == -200) {
                return AxiomI18n.get("axiom.key.scroll_up");
            }
            if (key == -201) {
                return AxiomI18n.get("axiom.key.scroll_down");
            }
            if (key == -202) {
                return AxiomI18n.get("axiom.key.scroll_left");
            }
            if (key == -203) {
                return AxiomI18n.get("axiom.key.scroll_right");
            }
            return class_3675.class_307.field_1672.method_1447(-key - 1).method_27445().getString();
        }
        return class_3675.method_15985((int)key, (int)-1).method_27445().getString();
    }

    public static void tick() {
        Int2IntLinkedOpenHashMap newVisuallyPressed = new Int2IntLinkedOpenHashMap();
        for (Int2IntMap.Entry entry : visuallyPressed.int2IntEntrySet()) {
            boolean isCurrentlyPressed = currentlyPressed.contains(entry.getIntKey());
            if (isCurrentlyPressed) {
                newVisuallyPressed.put(entry.getIntKey(), 20);
                continue;
            }
            int newValue = entry.getIntValue() - 1;
            if (newValue <= 0) continue;
            newVisuallyPressed.put(entry.getIntKey(), newValue);
        }
        visuallyPressed = newVisuallyPressed;
    }

    public record StringWithOpacity(String string, int opacity) {
    }
}

